/*
-----------------------------------------------------
   Application Name: QNetTraf
          File Name: host.h
         Start Date: 6/12/2009
       Last Changed: $LastChangedDate: 2010-01-19 18:12:52 +1300 (Tue, 19 Jan 2010) $
           Revision: $Revision: 179 $
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2009, 2010
            License: GNU General Public License
   File Description: Header for connection to nettrafd
-----------------------------------------------------
        This file is part of QNetTraf.

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

File Notes:
------------------
*/
#ifndef HOST_H
#define HOST_H

#include <QObject>
#include <QtDebug>
#include <QTcpSocket>
#include <QString>
#include <QMessageBox>

class Host : public QObject
{
    Q_OBJECT

public:
    /** Constructs a new Host with the specified settings
      \param hostname The host to connect to
      \param port The port to connect to
      \param password The password the host is expecting
      \param iface The interface name
      \param tiemout The timeout
      \param newif newif
     */
    Host(QString hostname, int port, QString password, QString iface, int timeout, bool newif);

    /** Class Destructor */
    ~Host();


    /** Connets to the host setup in the constructor
      \returns True if the connect succeeded, False if it failed
      */
    bool hostConnect();

    /** Disconnects from the current host
      \returns True on success, False on failure
      */
    bool hostDisconnect();

    /** Sends Quit command to the server telling the server to disconnect.
     */
    void quit();

    /** Sends Die command to the server telling the server to disconnect and exit.
      */
    void die();

public slots:
    /** Process data recieved
     */
    void dataArrived();

    /** Handle disconnect - just emits the disconnected signal.
     */
    void socketDisconnected();

signals:
    /** Signals network activity on the monitored interface.
      \param in Data recieved in bytes
      \param out Data sent in bytes
     */
    void activity(long in, long out);

    /** The interfaces IP address has been given to us by the
      server
      \param ipaddress The IP Address of the interface being monitored.
     */
    void ipset(QString ipaddress);

    /** The connection to the server has been lost.
     */
    void disconnected();

    /** The server has sent the ERROR command
     */
    void error();

private:
    QTcpSocket *socket_ptr; /*!< Pointer to the network socket */
    QString ip_address;     /*!< The IP Address of monitored interface */
    QString m_iface;        /*!< The interface to monitor */
    QString m_hostname;     /*!< The hostname of the server */
    int m_port;             /*!< The port to connect on */
    bool m_newif;           /*!< If true the Nettrafd v1.3 protocol is used */
    int m_timeout;          /*!< Maximum time to wait for connect to succeed */
    QString m_passwd;       /*!< The password (used by Nettraf v1.4+) */

    long ibr_total;         /*!< Total recieved bytes. Required by Nettrafd v1.0 protocol */
    long obr_total;         /*!< Total sent bytes. Required by Nettraf v1.0 protocol */
    long m_samples;         /*!< Total samples. Used for average computations. */
    long ibr_average;       /*!< Incoming average */
    long obr_average;       /*!< Outgoing average */

    long max_ibr;           /*!< Maximum received value */
    long max_obr;           /*!< Maximum sent value */

    long ibr;               /*!< Incoming byte rate */
    long obr;               /*!< Outgoing byte rate */
};

#endif // HOST_H
