/*
-----------------------------------------------------
   Application Name: QNetTraf
          File Name: graphscene.h
         Start Date: 6/12/2009
       Last Changed: $LastChangedDate: 2010-01-19 19:41:45 +1300 (Tue, 19 Jan 2010) $
           Revision: $Revision: 183 $
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2009, 2010
            License: GNU General Public License
   File Description: Graph Widget header
-----------------------------------------------------
        This file is part of QNetTraf.

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

File Notes:
------------------
*/

#ifndef GRAPHSCENE_H
#define GRAPHSCENE_H

#include <QWidget>
#include <QList>
#include <QPainter>
#include <QtDebug>
#include <QString>
#include <limits.h>

class GraphScene : public QWidget
{
    Q_OBJECT

    // Define a few properties
    Q_PROPERTY(QPen pen READ pen WRITE setPen)
    Q_PROPERTY(QBrush background_colour READ backgroundColour WRITE setBackgroundColour)
    Q_PROPERTY(bool show_leading_line READ isHeadLineEnabled WRITE setHeadLineEnabled )
    Q_PROPERTY(bool show_help READ isHelpEnabled WRITE setHelpEnabled)
public:
    GraphScene(QWidget *parent);

    void addSample(long value);

    // Pen colour. Used to draw the graph
    void setPen(QPen p) { m_pen = p; repaint(); }
    QPen pen() { return m_pen; }

    // Background colour
    void setBackgroundColour(QBrush b) {m_background = b;}
    QBrush backgroundColour() {return m_background;}

    // Leading Line enabled
    bool isHeadLineEnabled() {return m_head_line_enabled;}
    void setHeadLineEnabled(bool hle) { m_head_line_enabled = hle;}

    bool isHelpEnabled() {return m_help_enabled; }
    void setHelpEnabled(bool enabled) {m_help_enabled = enabled; }

    // Calculates the appropriate scaling factor and returns it
    float calculate_scale();

    // Applies the specified scaling factor
    void rescale(float scale_factor);

    void paintEvent(QPaintEvent *);

    // Sets the maximum sample value to use when rescaling the graph.
    // Setting a big value will scale all samples down, setting a small one
    // will scale all samples up.
    // If the supplied maximum value is less than the graphs maximum value
    // then the supplied value will be overridden and  the
    // maximum_value_changed signal will be emitted.
    void set_maximum_value(long new_max) {supplied_maximum_value = new_max;}
    long get_maximum_value() {return local_max_value; }

    void reset();

    QSize sizeHint() const;

    long getAverage() {return average;}
signals:
    void maximum_value_changed(long new_max);

private:

    // Converts Bytes into Kilobytes, Megabytes, Gigabytes or Terabytes
    // pass in size as the value to convert and units as an empty QString.
    // if i is true then units will be KiB, MiB, GiB, TiB instead of
    // the usual KB, MB, GB, TB.
    void convert_size(double * size, QString * units, bool i);

    void print_speed(QPainter * painter, double speed, QPen pen, QRectF rect,
                     QFont font, int flags, QString name);

    QList<QLine> make_dashed_line(int start_x, int end_x, int y, int dash_length);

    QPen get_graph_colour(int sample);

    QList<long> samples;
    QList<QLine> lines;

    // Properties
    QPen m_pen;
    QBrush m_background;
    bool m_head_line_enabled;
    QPen m_head_line_pen;
    bool m_use_i;
    bool m_average_display_enabled;
    bool m_speed_display_enabled;
    bool m_min_speed_display_enabled;
    bool m_max_speed_display_enabled;
    bool m_enable_gradient;
    QString m_std_dbl_format_string;
    QString m_min_dbl_format_string;
    bool m_help_enabled;

    long supplied_maximum_value;
    long running_total;
    long scaled_average;
    long average;
    long local_max_value;
    long old_max_value;
    long min_value;
};

#endif // GRAPHSCENE_H
