/*
-----------------------------------------------------
   Application Name: QNetTraf
          File Name: configuration.cpp
         Start Date: 6/12/2009
       Last Changed: $LastChangedDate: 2010-01-19 18:12:52 +1300 (Tue, 19 Jan 2010) $
           Revision: $Revision: 179 $
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2009, 2010
            License: GNU General Public License
   File Description: Configuration Dialog Implementation
-----------------------------------------------------
        This file is part of QNetTraf.

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

File Notes:
------------------
*/
#include "configuration.h"
#include "ui_configuration.h"

Configuration::Configuration(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::configuration)
{
    m_ui->setupUi(this);

    connect(m_ui->buttonBox, SIGNAL(accepted()),this,SLOT(accepted()));

    // Load all the settings
    m_ui->leHostname->setText(SettingsManager::getHostName());
    m_ui->leIface->setText(SettingsManager::getInterfaceName());
    m_ui->lePassword->setText(SettingsManager::getPassword());
    m_ui->lePort->setText(QString::number(SettingsManager::getPort()));
    m_ui->chkLogData->setChecked(SettingsManager::isLogDataEnabled());
    m_ui->chkTitleSpeed->setChecked(SettingsManager::isTitlebarSpeedEnabled());
    if(SettingsManager::getProtocolVersion() == 2)
        m_ui->chkNIF->setChecked(true);
    else
        m_ui->chkNIF->setChecked(false);
    m_ui->chkTabs->setChecked(SettingsManager::isTabWidgetEnabled());
}

Configuration::~Configuration()
{
    delete m_ui;
}

void Configuration::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Configuration::accepted() {

    // Save all the settings.
    SettingsManager::setHostName(m_ui->leHostname->text());
    SettingsManager::setInterfaceName(m_ui->leIface->text());
    SettingsManager::setPassword(m_ui->lePassword->text());
    SettingsManager::setPort(m_ui->lePort->text().toInt());
    SettingsManager::setLogDataEnabled(m_ui->chkLogData->isChecked());
    SettingsManager::setTitlebarSpeedEnabled(m_ui->chkTitleSpeed->isChecked());
    if (m_ui->chkNIF->isChecked())
        SettingsManager::setProtocolVersion(2);
    else
        SettingsManager::setProtocolVersion(1);
    SettingsManager::setTabWidgetEnabled(m_ui->chkTabs->isChecked());
    accept();
}
