/*
-----------------------------------------------------
   Application Name: QNetTraf
          File Name: settingsmanager.h
         Start Date: 16/01/2010
       Last Changed: $LastChangedDate: 2010-01-19 18:12:52 +1300 (Tue, 19 Jan 2010) $
           Revision: $Revision: 179 $
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2009, 2010
            License: GNU General Public License
   File Description: Settings Manager Header
-----------------------------------------------------
        This file is part of QNetTraf.

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

File Notes:
------------------
*/

#ifndef SETTINGSMANAGER_H
#define SETTINGSMANAGER_H

#include <QObject>
#include <QSettings>
#include <QFile>
#include <QCoreApplication>

class SettingsManager : public QObject
{
Q_OBJECT
public:
    explicit SettingsManager(QObject *parent = 0);

    static void loadSettings();
    static void closeSettings();

    static QString getHostName();
    static void setHostName(QString hostname);

    static int getPort();
    static void setPort(int port);

    static QString getInterfaceName();
    static void setInterfaceName(QString iface);

    static int getProtocolVersion();
    static void setProtocolVersion(int version);

    static QString getPassword();
    static void setPassword(QString password);

    static bool isLogDataEnabled();
    static void setLogDataEnabled(bool enabled);

    static bool isTitlebarSpeedEnabled();
    static void setTitlebarSpeedEnabled(bool enabled);

    static bool isSystemTrayHintShown();
    static void setSystemTrayHintShown(bool enabled);

    static int getSysTrayMessageTimeout();
    static void setSysTrayMessageTimeout(int timeout);

    static int getConnectionRetryTimeout();
    static void setConnectionRetryTimeout(int timeout);

    static bool isHelpEnabled();
    static void setHelpEnabled(bool enabled);

    static bool isTabWidgetEnabled();
    static void setTabWidgetEnabled(bool enabled);

    static bool isMinimiseOnCloseEnabled();
    static void setMinimiseOnCloseEnabled(bool enabled);

    static bool showConfigDialog();
    static void setShowConfigDialog(bool enabled);

    static QString getStatusIconStyle();
    static void setStatusIconStyle(QString style);

    // Messages - these don't have set functions.
    static QString getReconnectedMessageTitle();
    static QString getReconnectedMessageBody();
    static QString getReconnectedMessageURL();

    static QString getFailedConnectMessageTitle();
    static QString getFailedConnectMessageBody();
    static QString getFailedConnectMessageURL();

    static QString getDisconnectedMessageTitle();
    static QString getDisconnectedMessageBody();
    static QString getDisconnectedMessageURL();

    static QString getInvalidInterfaceMessageBody(bool always_invalid);
    static QString getInvalidInterfaceMessageURL(bool always_invalid);

    static QString getNowValidMessageTitle();
    static QString getNowValidMessageBody();
    static QString getNowValidMessageURL();

private:
    static QString getMessageValue(QString message_name, QString value_name, QString def_message);

    static QSettings *settings;
};

#endif // SETTINGSMANAGER_H
