/*
-----------------------------------------------------
   Application Name: "DIMG"
Application Version: 0.2.0
          File Name: DiskGeometry.h
         Start Date: 21/11/2008
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008
            License: GNU General Public License
   File Description: Disk Geometry structure
-----------------------------------------------------
	This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	File Notes:
	------------------
*/

#ifndef DISKGEOMETRY_H
#define DISKGEOMETRY_H

/** Various Disk Geometry-related structures 
*/
namespace GeomStr {
	/** Defines data rates.
	 */
	typedef enum
	{
		RATE_HD,	/* Data rate for 1.4Mb 3.5"  in 3.5"  drive */
		RATE_DD,	/* Data rate for 360k  5.25" in 1.2Mb drive */
		RATE_SD,	/* Data rate for 720k  3.5"  in 3.5"  drive */
		RATE_ED		/* Data rate for 2.8Mb 3.5"  in 3.5"  drive */
	} DataRate;
}

struct DiskGeometry {
	int cylinders;  /*!< Number of cylinders the disk has. */
        int heads;	/*!< Number of heads (sides) the disk has. */
	int sectors;	/*!< Number of sectors per track */
	int sectorSize; /*!< Sector size (in bytes) */
	int sectorBase; /*!< The first physical sector number. Most systems
	    		     start numbering their sectors at 1; Acorn systems
	    		     start at 0, and Amstrad CPCs start at 65 or 193 */
	/**  Data rate. This will be one of DataRate::RATE_HD, DataRate::RATE_DD,
	     DataRate::RATE_SD or DataRate::RATE_ED*/
	GeomStr::DataRate dataRate;
	unsigned char rwGap;	/*!< Read/Write Gap length */
	unsigned char fmtGap;   /*!< Format Gap length */
};

#endif /* DISKGEOMETRY_H */
