#ifndef WINUTILS_H
#define WINUTILS_H

#include <QtGlobal>

#ifdef Q_OS_WIN32
#include <QPixmap>
#include <QString>
#include <windows.h>

namespace winutils {


    /** Converts a Windows HICON to a QPixmap while converting the alpha
      channel.

      This method was taken straight from qpixmap_win.cpp with only minor
      changes. The original was licensed under both the GNU GPL and GNU LGPL
      and is (C) Copyright Nokia Corporation. Version 4.5 of Qt was used.

      \param icon The icon to convert.
      \returns The input icon as a QPixmap.
     */
    QPixmap alphaPixmap( HICON const &icon);


    /** Gets the icon for a file on a windows system using the shell API.

      \param path The name of the file. The file does not have to exist.
      \param large If true, the large icon will be returned. Otherwise, the
            small icon will be returned.
      \param alpha If true, alpha channel conversion will be performed. If
            false, no alpha channel conversion will be performed.
      \returns The icon for the specified filename as a QPixmap.
     */
    QPixmap getFileIcon(QString path, bool large, bool alpha);

    /** Gets the icon for a file on a windows system using the shell API and
      converts it to a QPixmap doing alpha channel conversion along the way.

      \param path The name of the file. The file does not have to exist.
      \param large If true, the large icon will be returned. Otherwise, the
            small icon will be returned.
      \returns The icon for the specified filename as a QPixmap.
     */
    QPixmap getFileIcon(QString path, bool large);
}
#endif

#endif // WINUTILS_H
