#include "utils.h"
#include <QtDebug>

QByteArray utils::swapEndian(QByteArray b){
    QByteArray result;
    for (int i = (b.size() - 1); i >= 0; i--) {
        result.append(b.at(i));
    }

    return result;
}

int utils::byteArrayToIntS(QByteArray b) {
    return byteArrayToInt(swapEndian(b));
}

int utils::byteArrayToInt(QByteArray b) {
    return byteArrayToInt(b,0);
}

int utils::byteArrayToInt(QByteArray b, int offset) {
    // turns four bytes into an integer.
    int value = 0, shift = 0;

    for (int i = 0; i < 4; i++) {
        shift = (3 - i) * 8;
        value += (b.at(i + offset) & 0x000000FF) << shift;
    }
    return value;
}

bool utils::getBit(char byte, int bit) {
    int i = byte >> (bit) & 0x00000001;

    if (i == 1) return true;
    else return false;
}

QByteArray utils::getBytes(QByteArray data, int start, int end, int length) {
    QByteArray qba = getBytes(data,start,end);

    // Now pad out to length.
    int nn = length - qba.size();

    for (int i = 1; i <= nn; i++) {
        qba.append('\0');
    }

    return qba;
}
// 17 18 4
QByteArray utils::getBytes(QByteArray data, int start, int end) {
    if (start < 0) qDebug() << "ERROR: Start is below 0";
    if (start >= data.size()) qDebug() << "ERROR: End is outside array";

    if (start == end) {
        QByteArray qba;
        qba.append(data.at(start));
        return qba;
    }
    if (end == start + 1) {
        QByteArray qba;
        qba.append(data.at(start));
        qba.append(data.at(end));
        return qba;
    }
    return data.mid(start,end-start);
}
