#include "fat12entry.h"

Fat12Entry::Fat12Entry(FAT12_DirEntry e, QString directory) {
    ent = e;
    entry_path = directory;
}

FSPlugin::Attributes Fat12Entry::getAttributes() const{
    FSPlugin::Attributes a(FSPlugin::A_NoAttributes);

    if (ent.isArchive())    a |= FSPlugin::A_Archive;
    if (ent.isDirectory())  a |= FSPlugin::A_Directory;
    if (ent.isHidden())     a |= FSPlugin::A_Hidden;
    if (ent.isReadOnly())   a |= FSPlugin::A_ReadOnly;
    if (ent.isSystemFile()) a |= FSPlugin::A_System;

    return a;
}

bool Fat12Entry::isDirectory() const{
    return ent.isDirectory();
}

quint64 Fat12Entry::getSize() const{
    return ent.getSize();
}

QString Fat12Entry::baseName() const{
    QStringList qsl = ent.fullFileName().split(".",QString::SkipEmptyParts);

    if (qsl.isEmpty()) return "";

    return qsl.at(0);
}

QString Fat12Entry::suffix() const{
    QStringList qsl = ent.fullFileName().split(".",QString::SkipEmptyParts);
    if (qsl.isEmpty()) return "";
    qsl.removeFirst();
    return qsl.join(".");
}

QString Fat12Entry::fileName() const{
    return ent.fullFileName();
}

QString Fat12Entry::filePath() const {
    QString p = path();
    if (!p.endsWith("/")) p.append("/");
    return p.append(fileName());
}

QString Fat12Entry::path() const{
    return entry_path;
}

QDate Fat12Entry::getDate(DateType dt) const {
    if (dt == FSEntry::D_CreatedDate) return ent.creationDate();
    if (dt == FSEntry::D_ModifiedDate) return ent.modificationDate();
    if (dt == FSEntry::D_AccessedDate) return ent.accessedDate();

    // An invalid date type was specified - probably a time was asked for.
    // Return an invalid QDate.
    return QDate();
}


QTime Fat12Entry::getTime(DateType dt) const {
    if (dt == FSEntry::D_CreatedTime) return ent.creationTime();
    if (dt == FSEntry::D_ModifiedTime) return ent.modificationTime();

    // an invalid date type was specified - probably a date was asked for,
    // or perhaps an access time (which FAT12 doesnt store). Return an invalid
    // QTime.
    return QTime();
}

QIcon Fat12Entry::getIcon() const{
#ifdef Q_OS_WIN32
    if (isDirectory()) {
        QFileIconProvider i;
        return i.icon(QFileIconProvider::Folder);
    }
    else {
        QPixmap qpm = winutils::getFileIcon(fileName(), false);
        QIcon i;
        i.addPixmap(qpm);
        qpm = winutils::getFileIcon(fileName(),true);
        i.addPixmap(qpm);
        return i;
    }
#else
    QFileIconProvider i;
    if (isDirectory())
        return i.icon(QFileIconProvider::Folder);
    else
        return i.icon(QFileIconProvider::File);
#endif
}
