#ifndef FAT12_BPB_H
#define FAT12_BPB_H

#include <QtDebug>
#include <QObject>
#include <QByteArray>
#include <QString>
#include "utils.h"

/** This class represents the BIOS Paramter Block.
 */
class FAT12_BPB : public QObject
{

public:
    FAT12_BPB(); /*!< Constructor */

    /** Constructor which automatically loads the BIOS Parameter block from
        the specified data.

        \param data The data to load this BIOS Parameter Block from
     */
    FAT12_BPB(QByteArray data);

    /** Loads the values in the BIOS Parameter Block from the supplied data.
      \param data The data to load into the BIOS Parameter Block
     */
    void load_data(QByteArray data);

    QString OEM_ID;             /*!< OEM_ID Field */
    int bytes_per_sector;       /*!< Number of Bytes per Cluster */
    int sectors_per_cluster;    /*!< Number of Sectors per Cluster */
    int reserved_sectors;       /*!< Number of Reserved Sectors */
    int total_fats;             /*!< Total number of File Allocation Tables */
    int max_root_entries;       /*!< Maximum number of entries in the root directory */
    int total_sectors;          /*!< Total number of sectors */
    int media_descriptor;       /*!< Media Descriptor */
    int sectors_per_fat;        /*!< Number of sectors in a File Allocation Table */
    int sectors_per_track;      /*!< Number of Sectors in a Track */
    int number_of_heads;        /*!< Number of Heads */
    int hidden_sectors;         /*!< Number of Hidden Sectors */
    int total_sectors_large;    /*!< Total number of sectors */
    int drive_number;           /*!< Drive Number*/
    int flags;                  /*!< Flags */
    int signature;              /*!< Signature */
    int volume_id;              /*!< Volume ID */
    QString volume_label;       /*!< Volume Label*/
    QString system_id;          /*!< System ID */
};

#endif // FAT12_BPB_H
