##########################################
#  libfat12fs - FAT12 filesystem plugin  #
##########################################

TEMPLATE = lib
CONFIG += plugin
INCLUDEPATH += ../include

### Build Mode stuff
CONFIG += release

CONFIG(debug, debug|release) {
    TARGET = $$join(TARGET,,,d)
    DEFINES += _DIMG_DEBUG
    win32:PREFIX = C:\temp\dimg
    unix:PREFIX = /tmp/dimg
}

RC_FILE = fat12fs.rc

# Generate install target
unix {
    isEmpty(PREFIX) {
        PREFIX = /opt/dimg
    }
}
win32 {
    isEmpty(PREFIX) {
        PREFIX = C:/dimg
    }
}

target.path = $$PREFIX/bin
INSTALLS += target

# Headers
HEADERS += src/fat12.h
HEADERS += src/fat12fs.h
HEADERS += src/fat12entry.h
HEADERS += src/winutils.h
HEADERS += src/about_dialog.h
HEADERS += src/fat12_bpb.h
HEADERS += src/fat12_directory.h
HEADERS += src/fat12_direntry.h
HEADERS += src/fat12_fat.h
HEADERS += src/utils.h

# Sources
SOURCES += src/fat12.cpp
SOURCES += src/fat12fs.cpp
SOURCES += src/fat12entry.cpp
SOURCES += src/winutils.cpp
SOURCES += src/about_dialog.cpp
SOURCES += src/fat12_bpb.cpp
SOURCES += src/fat12_directory.cpp
SOURCES += src/fat12_direntry.cpp
SOURCES += src/fat12_fat.cpp
SOURCES += src/utils.cpp

# Forms
FORMS += ui/about.ui

# For getting windows file icons, we need to link against GDI32 to use the
# Shell API.
win32:LIBS += libgdi32
