################################################################################
# QtDIMG - Build All                                                           #
################################################################################
#                                                                              #
# This project file builds all modules required by QtDIMG. These are:          #
#   DIMG        -- The main program                                            #
#   QFATreader  -- A supporting program (filesystem reader)                    #
#   fat12fs     -- FAT12 filesystem plugin                                     #
#   DQWindrv    -- Drive Access Plugin for Windows                             #
#   DQlibdskdrv -- Drive Access Plugin for Linux                               #
################################################################################

TEMPLATE = subdirs

# The main program
SUBDIRS += DIMG
SUBDIRS += fat12fs

# A supporting program. While not strictly necessary it is useful to have for
# now. It only adds ~105K (windows) to the uncompressed distribution.
SUBDIRS += QFATreader

# The drive access plugins. These are not currently cross-platform so there is
# one for windows and one for linux.
win32: SUBDIRS += DQWindrv
unix: SUBDIRS += DQlibdskdrv