#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QFileDialog>
#include <QtDebug>
#include <QFile>
#include <QTreeWidgetItem>
#include <QPluginLoader>
#include <QMessageBox>
#include <FSPlugin.h>
#include <fsentry.h>
#include "aboutdialog.h"
#include "fileproperties.h"

namespace Ui
{
    class MainWindowClass;
}

/** The applications Main Window.
 */
class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);    /*!< Constructor */
    ~MainWindow();  /*!< Destructor */

    void loadPlugin();

public slots:
    void open();    /*!< Displays an open-file dialog */
    /** Opens the specified file.
      \param filename The Disk Image to load.
     */
    void open(QString filename);
    void exit(); /*!< Exits the program */

    void extract_file(); /*!< Extracts the currently selected file */

    void show_file_properties(); /*!< Shows the properties of the currently selected file */

    void show_about();  /*!< Shows the plugins about dialog */

    void show_configure();  /*!< Shows the plugins configure dialog */

    void show_app_about(); /*!< Shows the applications about dialog */

private:
    /** A recursive function that populates the file tree.

      \param parent The parent widget
      \param directory The directory to load.
     */
    void populateTree(QTreeWidgetItem *parent, QString directory);
    Ui::MainWindowClass *ui;    /*!< The User Interface */
    QFile *file;    /*!< The file that the filesystem is working from */
    FSPlugin *p;     /*!< The plugin which provides our filesystem */
};

#endif // MAINWINDOW_H
