#include "aboutdialog.h"
#include "ui_aboutdialog.h"

AboutDialog::AboutDialog(QString pluginName, QString pluginVersion, QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::AboutDialog)
{
    m_ui->setupUi(this);

    // Setup the table on the about tab:
    QStringList data;
    data << "Filesystem Plugin";
    data << pluginName;
    data << QString::fromAscii(qVersion());
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    data << "Plugin Version";
    data << pluginVersion;
    data << QString::fromAscii(qVersion());
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    data << "Qt Version";
    data << QString::fromAscii(qVersion());
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    // Include some more detailed build information if the compiler was GNU GCC
#ifdef __GNUC__
    data << "Compiler Version";
    data << "GNU GCC " + QString::fromAscii(__VERSION__);
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    data << "Build Date";
    data << QString::fromAscii(__DATE__);
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();
#endif


}

AboutDialog::~AboutDialog()
{
    delete m_ui;
}

void AboutDialog::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
