# Qt Configuration
TEMPLATE = lib
CONFIG += plugin \
    warn_on

# ## Build Mode stuff
CONFIG += release
CONFIG(debug, debug|release) { 
    TARGET = $$join(TARGET,,,d)
    DEFINES += _DIMG_DEBUG
    CONFIG += console # For debugging output
    win32:PREFIX = C:\temp\dimg
    unix:PREFIX = /tmp/dimg
}

# Application include stuff
INCLUDEPATH += ../include

# LibDsk include stuff. Edit as required.
win32:INCLUDEPATH += C:/libdsk
unix:INCLUDEPATH += /usr/local/include

RC_FILE = DQlibdskdrv.rc

# Generate install target
unix {
    isEmpty(PREFIX) {
        PREFIX = /opt/dimg
    }
}
win32 {
    isEmpty(PREFIX) {
        PREFIX = C:/dimg
    }
}

target.path = $$PREFIX/bin

INSTALLS += target

# Header files
HEADERS += src/about.h
HEADERS += src/DQDLibDsk.h
HEADERS += src/qlibdsk.h
HEADERS += src/constants.h
unix: HEADERS += src/uxsettings.h

# Source files
SOURCES += src/about.cpp
SOURCES += src/DQDLibDsk.cpp
SOURCES += src/qlibdsk.cpp
unix:SOURCES += src/uxsettings.cpp
# The user interface file(s)
FORMS = ui/about.ui
FORMS += ui/uxsettings.ui

# LibDsk is needed. Edit as required.
unix:LIBS = -L/usr/local/lib \
    -ldsk
win32:LIBS += C:\libdsk\libdsk.lib
