/*
-----------------------------------------------------
   Application Name: "DIMG"
          Copyright: (C) Copyright David Goodwin, 2009
            License: GNU General Public License
-----------------------------------------------------
        This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

        File Notes:
        ------------------
*/

#ifndef GEOM_H
#define GEOM_H

#include <QByteArray>
#include <QtDebug>

#include <DiskGeometry.h>
#include "geom_err.h"

/** A collection of utility functions.
 */
namespace geom_detect {
    /** Attempts to read out a DOS disk geometry and returns it in the
      supplied DiskGeometry structure.

      The implementation of this function is derived from LibDsk which is
      licensed under the GNU LGPL.

      LIBDSK: General floppy and diskimage access library
      Copyright (C) 2001  John Elliott <jce@seasip.demon.co.uk>
     */
    int dosgeom(DiskGeometry *geom, const QByteArray *bootsect);
}

#endif // GEOM_H
