#include "utils.h"
#include <QtDebug>

QByteArray utils::swapEndian(QByteArray b){
    QByteArray result;
    for (int i = (b.size() - 1); i >= 0; i--) {
        result.append(b.at(i));
    }

    return result;
}

int utils::byteArrayToIntS(QByteArray b) {
    return byteArrayToInt(swapEndian(b));
}

int utils::byteArrayToInt(QByteArray b) {
    return byteArrayToInt(b,0);
}

int utils::byteArrayToInt(QByteArray b, int offset) {
    // turns four bytes into an integer.
    int value = 0, shift = 0;

    for (int i = 0; i < 4; i++) {
        shift = (3 - i) * 8;
        value += (b.at(i + offset) & 0x000000FF) << shift;
    }
    return value;
}

bool utils::getBit(char byte, int bit) {
    int i = byte >> (bit) & 0x00000001;

    if (i == 1) return true;
    else return false;
}

QByteArray utils::getBytes(QByteArray data, int start, int end, int length) {
    QByteArray qba = getBytes(data,start,end);

    // Now pad out to length.
    int nn = length - qba.size();

    for (int i = 1; i <= nn; i++) {
        qba.append('\0');
    }

    return qba;
}
// 17 18 4
QByteArray utils::getBytes(QByteArray data, int start, int end) {
    if (start < 0) qDebug() << "ERROR: Start is below 0";
    if (start >= data.size()) qDebug() << "ERROR: End is outside array";

    if (start == end) {
        QByteArray qba;
        qba.append(data.at(start));
        return qba;
    }
    if (end == start + 1) {
        QByteArray qba;
        qba.append(data.at(start));
        qba.append(data.at(end));
        return qba;
    }
    return data.mid(start,end-start);
}

QStringList utils::getFloppyDrives() {
        QStringList qsl;
        for (int i = 0; i < constants::floppy_drive_count; i++)
                qsl.append(QString(constants::floppy_drives[i]));

#ifdef Q_OS_WIN32
        if (constants::detect_floppy_drives) {
                qsl.clear();
                for (int j = 0; j < constants::win32_drive_count; j++) {
                        UINT dt = GetDriveTypeA(QString(constants::win32_drives[j] + ":").toAscii().constData());

                        QString msg = "Drive ";
                        msg.append(constants::win32_drives[j]);
                        msg.append(" is ");

                        if (dt == DRIVE_UNKNOWN)
                                msg.append("DRIVE_UNKNOWN");
                        else if (dt == DRIVE_NO_ROOT_DIR)
                                msg.append("DRIVE_NO_ROOT_DIR");
                        else if (dt == DRIVE_REMOVABLE) {
                                msg.append("DRIVE_REMOVABLE");
                                qsl.append(QString(constants::win32_drives[j]) + ":");
                        }
                        else if (dt == DRIVE_FIXED)
                                msg.append("DRIVE_FIXED");
                        else if (dt == DRIVE_REMOTE)
                                msg.append("DRIVE_REMOTE");
                        else if (dt == DRIVE_CDROM)
                                msg.append("DRIVE_CDROM");
                        else if (dt == DRIVE_RAMDISK)
                                msg.append("DRIVE_RAMDISK");
                        else
                                msg.append("unknown :(");

                        // Debugging stuff
                        //QMessageBox::information(NULL, "", msg);
                        qDebug() << msg;
                }
        }
#endif

        return qsl;
}

QString utils::versionString() {
        QString major; major.setNum(version::major_version);
        QString minor; minor.setNum(version::minor_version);
        QString patch; patch.setNum(version::patch_level);
        QString rev; rev.setNum(version::revision);
        QString rsn; rsn.setNum(version::release_series_number);

        QString versionString = major + "." + minor;

        if (version::release_type == version::RELEASE_STABLE) {
            if (version::patch_level > 0) {
                    if (version::use_standard_version_string)
                            versionString.append(".");
                    else
                            versionString.append("-");
                     versionString.append(patch);
            }
        } else if (version::release_type == version::RELEASE_DEVELOPMENT) {
            versionString = "Revision " +  rev;
        } else {
            /* Build type is either:
                 Pre-Alpha
                 Alpha
                 Beta
                 Release Candidate
             */
            switch (version::release_type) {
                case version::RELEASE_PREALPHA:
                    versionString.append(" Pre-Alpha ");
                    break;
                case version::RELEASE_ALPHA:
                    versionString.append(" Alpha ");
                    break;
                case version::RELEASE_BETA:
                    versionString.append(" Beta ");
                    break;
                case version::RELEASE_RC:
                    versionString.append(" RC ");
                    break;
                default:
                    versionString.append(" Unknown Build Type ");
            }
            versionString.append(rsn);
        }

#ifdef _DIMG_DEBUG
        return  versionString + " DEBUG";
#else
        return  versionString;
#endif
}
