/*
-----------------------------------------------------
   Application Name: "DIMG"
          File Name: main.cpp
         Start Date: 27/06/2008
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008,2009
            License: GNU General Public License
   File Description: Program entry point
-----------------------------------------------------
	This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	File Notes:
	------------------
*/


// ------------------
//   Header Files for Qt:
// ------------------

// Qt stuff
#include <QApplication>
#include <QtDebug>
#include <QStringList>
#include "Dimg.h"

/** Program entry point.
 */
int main(int argc, char *argv[])
{
    /*
    Steps that this function performs:
          1) Create app object (runs constructor)
          2) Create dimg object (runs constructor)
          3) Pass control to the app object
    */
   	
   	// Step 1:
        QApplication app(argc, argv);

        QCoreApplication::setOrganizationName("zxnet");
        QCoreApplication::setOrganizationDomain("zx.net.nz");
        QCoreApplication::setApplicationName("DIMG");

        // Step 2: Process command line args
        QString filename;
        QStringList args = app.arguments();
        if (args.count() > 1) {
            // We have been given arguments to interpret.
            // We only support one at the moment - open file.
            filename = args.at(1);
        }

        // Step 3:		(pass in apps memory address so it can be used by dimg)
	Dimg dmg(&app);

        // Step 4: Open a file if we've been told to do so
        if (!filename.isEmpty())
            dmg.loadFile(filename);

        // Step 5: Main Event Loop
	return app.exec();
}
