/*
-----------------------------------------------------
   Application Name: "DIMG"
          File Name: errors.h
         Start Date: 28/06/2008
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008
            License: GNU General Public License
   File Description: Constants
-----------------------------------------------------
        This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

        File Notes:
        ------------------
*/

#ifndef DIMG_ERRORS_H
#define DIMG_ERRORS_H

/** Contains error/status codes used by the program. These codes may be different
    from those returned by plugins.
  */
namespace errors {
    const int E_SUCCESS = 0;        /*!< Operation has succeeded */
    const int E_FAILURE = 1;        /*!< A generic error */
    const int E_USER_CANCELED = 2;  /*!< User canceled the operation */

    const int E_NO_DQDRIVER = 3;    /*!< No DQDriver plugin could be found */
    const int E_DQD_INCORRECT = 4;  /*!< DQDriver was of incorrect type */
    const int E_DQDRIVER_BAD = 5;   /*!< The DQDriver appears to be bad */

    const int E_NO_FS_PLUGIN = 6;   /*!< No Filesystem plugin could be found */
    const int E_FSP_INCORRECT = 7;  /*!< FSPlugin was of incorrect type */
    const int E_FSP_BAD = 8;        /*!< FSPlugin appears to be bad */

    const int E_CANT_OPEN_DEST_DEV = 9; /*!< Unable to open destination image */
    const int E_CANT_OPEN_SRC_DEV = 10; /*!< Unable to open source image */

    const int E_UNEXP_SEC_SIZE = 11;    /*!< The size of the sector read was not what was expected according to the Disk Geometry */

    // This should always have the highest number.
    const int E_UNKNOWN = 12; /*!< An unknown error. Should always have the next highest value. */
}
#endif // DIMG_ERRORS_H
