/*
-----------------------------------------------------
   Application Name: "DIMG"
Application Version: 0.2.0
          File Name: constants.h
       File Version: 0.1.0
         Start Date: 28/06/2008
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008
            License: GNU General Public License
   File Description: Constants
-----------------------------------------------------
	This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	File Notes:
	------------------
*/

#ifndef DIMG_CONSTANTS_H
#define DIMG_CONSTANTS_H

/** Various constants used by the software. Some are settings.
 */
namespace constants {
    #ifdef Q_OS_WIN32
    const QString floppy_drives[] = {"A:", "B:"};   /*!< Default windows floppy drives */
    const int floppy_drive_count = 2;   /*!< Number of default windows floppy drives */
    const bool detect_floppy_drives = true;  /*!< Set this to FALSE to disable autodetection of floppy drives */
    const int win32_drive_count = 26; /*!< Number of windows drives */

    /** All windows drives
      */
    const QString win32_drives[] = {"A", "B", "C", "D", "E", "F",
                                    "G", "H", "I", "J", "K", "L",
                                    "M", "N", "O", "P", "Q", "R",
                                    "S", "T", "U", "V", "W", "X",
                                    "Y", "Z"};
    #else
    const QString floppy_drives[] = {"/dev/fd0", "/dev/fd1"}; /*!< Standard UNIX floppy drives */
    const int floppy_drive_count = 2; /*!< Number of standard UNIX floppy drives */
    #endif

    // Some basic configuration stuff (will likely move later)
    const bool size_units = true;   /*!< Set to True to convert FS sizes to bytes, kilobytes, megabytes, etc. */

}
#endif //DIMG_CONSTANTS_H
