# Configuration stuff
CONFIG += qt \
    warn_on

# ## Build Mode stuff
CONFIG += release
CONFIG(debug, debug|release) { 
    TARGET = $$join(TARGET,,,d)
    DEFINES += _DIMG_DEBUG
    CONFIG += console # For debugging output
    win32:PREFIX = C:\temp\dimg
    unix:PREFIX = /tmp/dimg
}
INCLUDEPATH = ../include

# Generate install target
unix {
    isEmpty(PREFIX) {
        PREFIX = /opt/dimg
    }
}
win32 {
    isEmpty(PREFIX) {
        PREFIX = C:/dimg
    }
}

target.path = $$PREFIX/bin
INSTALLS += target

RC_FILE = dimg.rc

# Header files
HEADERS += src/Dimg.h
HEADERS += src/version.h
HEADERS += src/utils.h
HEADERS += src/fileproperties.h
HEADERS += src/aboutdialog.h
HEADERS += src/errors.h
HEADERS += src/imager.h
HEADERS += src/errorstrings.h
HEADERS += src/constants.h

# Source files
SOURCES += src/main.cpp
SOURCES += src/utils.cpp
SOURCES += src/fileproperties.cpp
SOURCES += src/aboutdialog.cpp
SOURCES += src/imager.cpp
SOURCES += src/Dimg.cpp

# Forms (GUI stuff)
FORMS += ui/main_window.ui
FORMS += ui/fileproperties.ui
FORMS += ui/aboutdialog.ui

# Resource files
RESOURCES = resources.qrc
