#include "winutils.h"

#ifdef Q_OS_WIN32

/** This method was taken straight from qpixmap_win.cpp which is licensed
  under the GNU GPL and GNU LGPL. It is (C) Copyright Nokia Corporation.
 */
static QImage qt_fromWinHBITMAP(HDC hdc, HBITMAP bitmap, int w, int h)
{
    BITMAPINFO bmi;
    memset(&bmi, 0, sizeof(bmi));
    bmi.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
    bmi.bmiHeader.biWidth       = w;
    bmi.bmiHeader.biHeight      = -h;
    bmi.bmiHeader.biPlanes      = 1;
    bmi.bmiHeader.biBitCount    = 32;
    bmi.bmiHeader.biCompression = BI_RGB;
    bmi.bmiHeader.biSizeImage   = w * h * 4;

    QImage image(w, h, QImage::Format_ARGB32_Premultiplied);
    if (image.isNull())
        return image;

    // Get bitmap bits
    uchar *data = (uchar *) qMalloc(bmi.bmiHeader.biSizeImage);

    if (GetDIBits(hdc, bitmap, 0, h, data, &bmi, DIB_RGB_COLORS)) {
        // Create image and copy data into image.
        for (int y=0; y<h; ++y) {
            void *dest = (void *) image.scanLine(y);
            void *src = data + y * image.bytesPerLine();
            memcpy(dest, src, image.bytesPerLine());
        }
    } else {
        qWarning("qt_fromWinHBITMAP(), failed to get bitmap bits");
    }

    return image;
}

QPixmap winutils::alphaPixmap( HICON const &icon)
{

    bool foundAlpha = false;
    HDC screenDevice = GetDC(0);
    HDC hdc = CreateCompatibleDC(screenDevice);
    ReleaseDC(0, screenDevice);

    ICONINFO iconinfo;
    bool result = GetIconInfo(icon, &iconinfo); //x and y Hotspot describes the icon center
    if (!result)
        qWarning("convertHIconToPixmap(), failed to GetIconInfo()");

    int w = iconinfo.xHotspot * 2;
    int h = iconinfo.yHotspot * 2;

    BITMAPINFOHEADER bitmapInfo;
    bitmapInfo.biSize        = sizeof(BITMAPINFOHEADER);
    bitmapInfo.biWidth       = w;
    bitmapInfo.biHeight      = h;
    bitmapInfo.biPlanes      = 1;
    bitmapInfo.biBitCount    = 32;
    bitmapInfo.biCompression = BI_RGB;
    bitmapInfo.biSizeImage   = 0;
    bitmapInfo.biXPelsPerMeter = 0;
    bitmapInfo.biYPelsPerMeter = 0;
    bitmapInfo.biClrUsed       = 0;
    bitmapInfo.biClrImportant  = 0;
    DWORD* bits;

    HBITMAP winBitmap = CreateDIBSection(hdc, (BITMAPINFO*)&bitmapInfo, DIB_RGB_COLORS, (VOID**)&bits, NULL, 0);
    HGDIOBJ oldhdc = (HBITMAP)SelectObject(hdc, winBitmap);
    DrawIconEx( hdc, 0, 0, icon, iconinfo.xHotspot * 2, iconinfo.yHotspot * 2, 0, 0, DI_NORMAL);
    QImage image = qt_fromWinHBITMAP(hdc, winBitmap, w, h);

    for (int y = 0 ; y < h && !foundAlpha ; y++) {
        QRgb *scanLine= reinterpret_cast<QRgb *>(image.scanLine(y));
        for (int x = 0; x < w ; x++) {
            if (qAlpha(scanLine[x]) != 0) {
                foundAlpha = true;
                break;
            }
        }
    }
    if (!foundAlpha) {
        //If no alpha was found, we use the mask to set alpha values
        DrawIconEx( hdc, 0, 0, icon, w, h, 0, 0, DI_MASK);
        QImage mask = qt_fromWinHBITMAP(hdc, winBitmap, w, h);

        for (int y = 0 ; y < h ; y++){
            QRgb *scanlineImage = reinterpret_cast<QRgb *>(image.scanLine(y));
            QRgb *scanlineMask = mask.isNull() ? 0 : reinterpret_cast<QRgb *>(mask.scanLine(y));
            for (int x = 0; x < w ; x++){
                if (scanlineMask && qRed(scanlineMask[x]) != 0)
                    scanlineImage[x] = 0; //mask out this pixel
                else
                    scanlineImage[x] |= 0xff000000; // set the alpha channel to 255
            }
        }
    }
    //dispose resources created by iconinfo call
    DeleteObject(iconinfo.hbmMask);
    DeleteObject(iconinfo.hbmColor);

    SelectObject(hdc, oldhdc); //restore state
    DeleteObject(winBitmap);
    DeleteDC(hdc);

    // Force the pixmap to do a deep copy of the data
    QPixmap p = QPixmap::fromImage(image);
    QPixmap copy = p;
    copy.detach();
    p = copy;

    return p;
}

QPixmap winutils::getFileIcon(QString path, bool large = true, bool alpha = true) {
    SHFILEINFO file_info;

    /* Flags for SHGetFileInfo. Specifying SHGFI_USEFILEATTRIBUTES along with
       FILE_ATTRIBUTE_NORMAL means that the file specified by 'path' doesnt
       have to exist.
     */
    uint flags = SHGFI_USEFILEATTRIBUTES | SHGFI_ICON;

    // Set the icon size
    if (large)
        flags = flags | SHGFI_LARGEICON;
    else
        flags = flags | SHGFI_SMALLICON;


    // Get the file information.
    SHGetFileInfo((wchar_t *)path.utf16(),
                   FILE_ATTRIBUTE_NORMAL,
                   &file_info,
                   sizeof(SHFILEINFO),
                   flags);


    // Get the icons information
    ICONINFO info;
    GetIconInfo(file_info.hIcon,&info);

    QPixmap pixmap;

    // Get the pixmap
    if (alpha)
        pixmap = alphaPixmap(file_info.hIcon);
    else
        pixmap = QPixmap::fromWinHBITMAP(info.hbmColor,QPixmap::NoAlpha);

    // Now clean up our mess
    DeleteObject(info.hbmColor);
    DeleteObject(info.hbmMask);
    DestroyIcon(file_info.hIcon);

    // And return the result
    return pixmap;
}

QPixmap winutils::getFileIcon(QString path, bool large) {
    return getFileIcon(path, large, true);
}

#endif
