#include "fat12_bpb.h"

FAT12_BPB::FAT12_BPB()
{
}


FAT12_BPB::FAT12_BPB(QByteArray data) {
    load_data(data);
}

void FAT12_BPB::load_data(QByteArray data) {
    /* This is the format of the BIOS Parameter Block on a FAT12 formatted disk
    Jump (3 bytes) -- ignore this
    OEM_ID            db 8 bytes
    BytesPerSector    dw 0x0200        ;512 bytes per sector
    SectorsPerCluster db 0x01          ;1 sector per cluster
    ReservedSectors   dw 0x0001        ;Reserved sectors.. ie boot sector
    TotalFats         db 0x02          ;2 copies of the FAT
    MaxRootEntries    dw 0x0E00        ;Number of entries in the root. 224
    TotalSectors      dw 0x0B40        ;Number of sectors in volume 2880
    MediaDescriptor   db 0xF0          ; 1.44 floppy
    SectorsPerFat     dw 0x0009        ;Number of sectors in a FAT 9
    SectorsPerTrack   dw 0x0012        ;Sectors per Track 18
    NumHeads          dw 0x0002        ;2 heads
    HiddenSectors     dd 0x00000000
    TotalSectorsLarge dd 0x00000000
    DriveNumber       db 0x00
    Flags             db 0x00
    Signature        db 0x29
    VolumeID          dd 0xFFFFFFFF
    VolumeLabel       db "XXXXXXXXXXXX" ;12 bytes 8+"."+3
    SystemID          db "FAT12   "     ;8 bytes
    */

    // OEM_ID  -- ASCII String -- bytes 3 to 10
    OEM_ID = QString(utils::getBytes(data,3,10));

    // BytesPerSector -- integer -- bytes 11 and 12
    bytes_per_sector = utils::byteArrayToIntS(utils::getBytes(data,11,12,4));

    // SectorsPerCluster -- integer -- byte 13
    sectors_per_cluster = utils::byteArrayToIntS(utils::getBytes(data,13,13,4));

    // ReservedSectors -- integer -- bytes 14 and 15
    reserved_sectors = utils::byteArrayToIntS(utils::getBytes(data,14,15,4));

    // TotalFATs -- integer -- byte 16
    total_fats = utils::byteArrayToIntS(utils::getBytes(data,16,16,4));

    // MaxRootEntries -- integer -- bytes 17 and 18
    max_root_entries = utils::byteArrayToIntS(utils::getBytes(data,17,18,4));

    // TotalSectors -- integer -- bytes 19 and 20
    total_sectors = utils::byteArrayToIntS(utils::getBytes(data,19,20,4));

    // MediaDescriptor -- integer -- byte 21
    media_descriptor = utils::byteArrayToIntS(utils::getBytes(data,21,21,4));

    // SectorsPerFAT -- integer -- bytes 22 and 23
    sectors_per_fat = utils::byteArrayToIntS(utils::getBytes(data,22,23,4));

    // SectorsPerTrack -- integer -- bytes 24 and 25
    sectors_per_track = utils::byteArrayToIntS(utils::getBytes(data,24,25,4));

    // NumHeads -- integer -- bytes 26 and 27
    number_of_heads = utils::byteArrayToIntS(utils::getBytes(data,26,27,4));

    // HiddenSectors -- integer -- bytes 28 to 31
    hidden_sectors = utils::byteArrayToIntS(utils::getBytes(data,28,31,4));

    // TotalSectorsLarge -- integer -- bytes 32 to 35
    total_sectors_large = utils::byteArrayToIntS(utils::getBytes(data,32,35,4));

    // DriveNumber -- integer -- byte 36
    drive_number = utils::byteArrayToIntS(utils::getBytes(data,36,36,4));

    // Flags -- integer -- byte 37
    flags = utils::byteArrayToIntS(utils::getBytes(data,37,37,4));

    // Signature -- integer -- byte 38
    signature = utils::byteArrayToIntS(utils::getBytes(data,38,38,4));

    // VolumeID -- integer -- bytes 39 to 42
    volume_id = utils::byteArrayToIntS(utils::getBytes(data,39,42,4));

    // VolumeLabel -- string -- bytes 43 to 53
    volume_label = QString(utils::getBytes(data,43,53));

    // SystemID -- string == bytes 54 to 61
    system_id = QString(utils::getBytes(data,54,61));

    qDebug() << "BIOS Parameter Block Loaded.";
}
