#include <QtGui/QApplication>
#include "mainwindow.h"

void msgOutput(QtMsgType type, const char *msg)
{
     switch (type) {
     case QtDebugMsg:
             fprintf(stdout, "Debug: %s\n", msg);
             break;
     case QtWarningMsg:
             fprintf(stdout, "Warning: %s\n", msg);
             break;
     case QtCriticalMsg:
             fprintf(stdout, "Critical: %s\n", msg);
             break;
     case QtFatalMsg:
             fprintf(stdout, "Fatal: %s\n", msg);
             abort();
     }
}

int main(int argc, char *argv[])
{
    qInstallMsgHandler(msgOutput);

    QApplication a(argc, argv);
    MainWindow w;
    w.show();
    return a.exec();
}
