#include "fileproperties.h"
#include "ui_fileproperties.h"

FileProperties::FileProperties(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::FileProperties)
{
    m_ui->setupUi(this);
}

FileProperties::~FileProperties()
{
    delete m_ui;
}

void FileProperties::setFileEntry(FSEntry *e) {
    m_ui->lblIcon->setPixmap(e->getIcon().pixmap(32,32));
    m_ui->leFileName->setText(e->fileName());
    m_ui->leLocation->setText(QDir::toNativeSeparators("/" + e->path()));
    m_ui->leType->setText(e->suffix() + " File");

    m_ui->lblSize->setText(QString::number(e->getSize()));
    m_ui->lblDOSFilename->setText(e->fileName());

    // Attributes
    FSPlugin::Attributes a = e->getAttributes();
    m_ui->chkArchive->setChecked(a.testFlag(FSPlugin::A_Archive));
    m_ui->chkHidden->setChecked(a.testFlag(FSPlugin::A_Hidden));
    m_ui->chkReadOnly->setChecked(a.testFlag(FSPlugin::A_ReadOnly));
    m_ui->chkSystem->setChecked(a.testFlag(FSPlugin::A_System));

    // Date created
    if (e->getDate(FSEntry::D_CreatedDate).isValid()) {
        m_ui->dteCreated->setDate(e->getDate(FSEntry::D_CreatedDate));
        m_ui->dteCreated->setTime(e->getTime(FSEntry::D_CreatedTime));
    }
    else {
        m_ui->dteCreated->setVisible(false);
        m_ui->lblDateCreated->setVisible(false);
    }

    // Date modified
    if (e->getDate(FSEntry::D_ModifiedDate).isValid()) {
        m_ui->dteModified->setDate(e->getDate(FSEntry::D_ModifiedDate));
        m_ui->dteModified->setTime(e->getTime(FSEntry::D_ModifiedTime));
    } else {
        m_ui->dteModified->setVisible(false);
        m_ui->lblDateModified->setVisible(false);
    }

    // Date accessed
    if (e->getDate(FSEntry::D_AccessedDate).isValid())
        m_ui->deAccessed->setDate(e->getDate(FSEntry::D_AccessedDate));
    else {
        m_ui->deAccessed->setVisible(false);
        m_ui->lblDateAccessed->setVisible(false);
    }
}

void FileProperties::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
