#include "uxsettings.h"

uxsettings::uxsettings(QWidget *parent)
    : QDialog(parent)
{
    ui.setupUi(this);
    connect(ui.pbAdd,SIGNAL(clicked()),this,SLOT(add_floppy_drive()));
    connect(ui.pbRemove,SIGNAL(clicked()),this,SLOT(remove_floppy_drive()));
}

uxsettings::~uxsettings() {
    //
}

QStringList uxsettings::get_floppy_drives() {
    QStringList fds;
    for (int i = 0; i < ui.lwFloppyDrives->count(); i++) {
        fds.append(ui.lwFloppyDrives->item(i)->text());
    }
    return fds;
}

void uxsettings::add_floppy_drives(QStringList floppy_drives) {
    for (int i = 0; i < floppy_drives.count(); i++)
        ui.lwFloppyDrives->addItem(floppy_drives.at(i));
}

void uxsettings::add_floppy_drive() {
    QString fd = QInputDialog::getText(this,"Floppy Drive file","Floppy Drive file:",QLineEdit::Normal,"");
    ui.lwFloppyDrives->addItem(fd);
}

void uxsettings::remove_floppy_drive() {
    delete ui.lwFloppyDrives->takeItem(ui.lwFloppyDrives->currentRow());
}
