/*
-----------------------------------------------------
   Application Name: "DIMG"
Application Version: 0.1.0
          File Name: qlibdsk.h
       File Version: 0.0.1
         Start Date: 27/06/2008
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008
            License: GNU General Public License
   File Description: Qt wrapper around LibDsk
-----------------------------------------------------
	This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	File Notes:
	------------------
*/


#ifndef QLIBDSK_H
#define QLIBDSK_H

// ------------------
// Headder files:
// ------------------
#include <QObject>
#include <QString>
#include <QStringList>
#include <QtDebug>
#include <libdsk.h>

class QLibDsk : public QObject
{
    Q_OBJECT

public:
    // Public Functions:
    QLibDsk();	/*!< The Class Constructor */

    // Functions to open and close disks / disk images
    dsk_err_t open(QString filename, const char *type, const char *compress);
    dsk_err_t open(QString filename);
    dsk_err_t creat(QString filename, const char *type, const char *compress);
    dsk_err_t close();

    // format stuff
    dsk_err_t getgeom(DSK_GEOMETRY *geom);
    QString compname();
    QString compdesc();
    QString drvname();
    QString drvdesc();

    // settings
    dsk_err_t set_retry(unsigned int count);
    dsk_err_t get_retry(unsigned int *count);

    // Formatting stuff
    dsk_err_t apform(DSK_GEOMETRY *geom, dsk_pcyl_t cylinder, dsk_phead_t head, unsigned char filler);
    dsk_err_t alform(DSK_GEOMETRY *geom, dsk_ltrack_t track, unsigned char filler);

    // Status stuff
    dsk_err_t drive_status(const DSK_GEOMETRY *geom, dsk_phead_t head, unsigned char *result);
    dsk_err_t get_comment(QString *comment);
    dsk_err_t set_comment(const char *comment);

    // Disk Sector stuff
    dsk_err_t pwrite(const DSK_GEOMETRY *geom, const void *buf, dsk_pcyl_t cylinder, dsk_phead_t head, dsk_psect_t sector);
    dsk_err_t lwrite(const DSK_GEOMETRY *geom, const void *buf, dsk_lsect_t sector);
    dsk_err_t pread(const DSK_GEOMETRY *geom, void *buf, dsk_pcyl_t cylinder, dsk_phead_t head, dsk_psect_t sector);
    dsk_err_t lread(const DSK_GEOMETRY *geom, void *buf, dsk_lsect_t sector);

    // Disk Track stuff
    dsk_err_t ltread(const DSK_GEOMETRY *geom, void *buf, dsk_ltrack_t track);
    dsk_err_t ptread(const DSK_GEOMETRY *geom, void *buf, dsk_pcyl_t cylinder, dsk_phead_t head);

    // static functions
    static QString strerror(dsk_err_t err);
    static void reportfunc_set(DSK_REPORTFUNC report, DSK_REPORTEND repend);
    static void reportfunc_get(DSK_REPORTFUNC *report, DSK_REPORTEND *repend);
    static dsk_err_t stdformat(DSK_GEOMETRY *self, dsk_format_t formatid, dsk_cchar_t *fname, dsk_cchar_t *fdesc);

    // New functions not present in LibDsk
    static QStringList list_format_names();
    static QStringList list_format_descriptions();

private:
    bool checkDskPointer();

    DSK_PDRIVER dsk;
};

#endif // QLIBDSK_H
