/*
-----------------------------------------------------
   Application Name: "DIMG"
Application Version: 0.1.0
          File Name: qlibdsk.cpp
       File Version: 0.0.1
         Start Date: 27/06/2008
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008
            License: GNU General Public License
   File Description: Qt Wrapper around LibDsk
-----------------------------------------------------
	This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	File Notes:
	------------------
*/



// ------------------
// Headder files:
// ------------------
#include "qlibdsk.h"

QLibDsk::QLibDsk(){
	dsk = NULL;
}

dsk_err_t QLibDsk::open(QString filename, const char *type, const char *compress) {
	return dsk_open(&dsk, filename.toAscii().constData(), type, compress);
}

dsk_err_t QLibDsk::open(QString filename) {
	return open(filename, NULL, NULL);
}

dsk_err_t QLibDsk::creat(QString filename, const char *type, const char *compress) {
	return dsk_creat(&dsk, filename.toAscii().constData(), type, compress);
}

dsk_err_t QLibDsk::close() {
	return dsk_close(&dsk);
}

dsk_err_t QLibDsk::getgeom(DSK_GEOMETRY *geom){
    checkDskPointer();
	return dsk_getgeom(dsk, geom);
}
QString QLibDsk::compname() {
    checkDskPointer();
	return QString::fromAscii(dsk_compname(dsk));
}
QString QLibDsk::compdesc() {
    checkDskPointer();
	return QString::fromAscii(dsk_compdesc(dsk));
}
QString QLibDsk::drvname() {
    checkDskPointer();
	const char *str = dsk_drvname(dsk);

	if (str == NULL)
		return "None";
	else
		return QString::fromAscii(str);
}
QString QLibDsk::drvdesc() {
    checkDskPointer();
	return QString::fromAscii(dsk_drvdesc(dsk));
}


QString QLibDsk::strerror(dsk_err_t err) {
	return QString::fromAscii(dsk_strerror(err));
}

dsk_err_t QLibDsk::drive_status(const DSK_GEOMETRY *geom, dsk_phead_t head, unsigned char *result){
    checkDskPointer();
	return dsk_drive_status(dsk, geom, head, result);
}

dsk_err_t QLibDsk::set_retry(unsigned int count) {
    checkDskPointer();
	return dsk_set_retry(dsk,count);
}
dsk_err_t QLibDsk::get_retry(unsigned int *count){
    checkDskPointer();
	return dsk_get_retry(dsk,count);
}

// Returns:
//  NULL if no comment
//  a NEW QString if there is a comment.
dsk_err_t QLibDsk::get_comment(QString *comment){
    checkDskPointer();
	char *commentc;
	dsk_err_t err;
	err = dsk_get_comment(dsk, &commentc);
	if (commentc == NULL)
		comment = NULL;
	else
		comment = new QString(commentc);
	return err;
}

dsk_err_t QLibDsk::set_comment(const char *comment) {
	return dsk_set_comment(dsk, comment);
}


QStringList QLibDsk::list_format_names() {
	QStringList list;

	int idx =  0;
	const char *formname = NULL;
	const char *formdesc = NULL;
	dsk_err_t err;

	do
	{
		err = dg_stdformat(NULL, (dsk_format_t)idx, &formname, &formdesc);
		if (err == DSK_ERR_OK)
		{
			list << formname;
		}
		++idx;
	}
	while (err == DSK_ERR_OK);

	return list;
}

QStringList QLibDsk::list_format_descriptions() {
	QStringList list;

	int idx =  0;
	const char *formname = NULL;
	const char *formdesc = NULL;
	dsk_err_t err;

	do
	{
		err = stdformat(NULL, (dsk_format_t)idx, &formname, &formdesc);
		if (err == DSK_ERR_OK)
		{
			list << formdesc;
		}
		++idx;
	}
	while (err == DSK_ERR_OK);

	return list;
}

dsk_err_t QLibDsk::stdformat(DSK_GEOMETRY *self, dsk_format_t formatid, dsk_cchar_t *fname, dsk_cchar_t *fdesc) {
	return dg_stdformat(self, formatid, fname, fdesc);
}

void QLibDsk::reportfunc_set(DSK_REPORTFUNC report, DSK_REPORTEND repend){
	dsk_reportfunc_set(report,repend);
}
void QLibDsk::reportfunc_get(DSK_REPORTFUNC *report, DSK_REPORTEND *repend){
	dsk_reportfunc_get(report,repend);
}

dsk_err_t QLibDsk::apform(DSK_GEOMETRY *geom, dsk_pcyl_t cylinder, dsk_phead_t head, unsigned char filler){
    checkDskPointer();
	return dsk_apform(dsk,geom,cylinder,head,filler);
}

dsk_err_t QLibDsk::alform(DSK_GEOMETRY *geom, dsk_ltrack_t track, unsigned char filler) {
    checkDskPointer();
	return dsk_alform(dsk, geom, track, filler);
}

dsk_err_t QLibDsk::pwrite(const DSK_GEOMETRY *geom, const void *buf, dsk_pcyl_t cylinder, dsk_phead_t head, dsk_psect_t sector){
    checkDskPointer();
	return dsk_pwrite(dsk, geom, buf, cylinder, head, sector);
}

dsk_err_t QLibDsk::lwrite(const DSK_GEOMETRY *geom, const void *buf, dsk_lsect_t sector) {
    checkDskPointer();
	return dsk_lwrite(dsk, geom, buf, sector);
}

dsk_err_t QLibDsk::pread(const DSK_GEOMETRY *geom, void *buf, dsk_pcyl_t cylinder, dsk_phead_t head, dsk_psect_t sector){
    checkDskPointer();
	return dsk_pread(dsk, geom, buf, cylinder, head, sector);
}

dsk_err_t QLibDsk::lread(const DSK_GEOMETRY *geom, void *buf, dsk_lsect_t sector) {
    checkDskPointer();
    return dsk_lread(dsk,geom,buf,sector);
}

dsk_err_t QLibDsk::ltread(const DSK_GEOMETRY *geom, void *buf, dsk_ltrack_t track) {
    checkDskPointer();
    return dsk_ltread(dsk, geom, buf, track);
}

dsk_err_t QLibDsk::ptread(const DSK_GEOMETRY *geom, void *buf, dsk_pcyl_t cylinder, dsk_phead_t head) {
    checkDskPointer();
    return dsk_ptread(dsk, geom, buf, cylinder, head);
}

bool QLibDsk::checkDskPointer() {
    if (dsk == 0) {
        qDebug() << "Warning: Drive not open (DSK pointer is NULL)";
        return false;
    }
    return true;
}
