/*
-----------------------------------------------------
   Application Name: "DIMG" DQDLibDsk plugin
Application Version: 0.2.0
          File Name: constants.h
       File Version: 0.1.0
         Start Date: 28/06/2008
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008
            License: GNU General Public License
   File Description: Constants
-----------------------------------------------------
	This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	File Notes:
	------------------
*/

#include <Qt>

static const int ERR_OK = 0;
static const int ERR_NOTIMPL = 1;
static const int ERR_USRCANCVIRTMNT = 2;

// For now the virtual drive is enabled only on debug builds.
#ifdef _DIMG_DEBUG
static const bool enable_virtual_drive = true;
#else
static const bool enable_virtual_drive = false;
#endif

#ifdef Q_OS_WIN32
static const QString floppy_drives[] = {"A:", "B:"};
static const int floppy_drive_count = 2;
#else
static const QString floppy_drives[] = {"/dev/fd0", "/dev/fd1"};
static const int floppy_drive_count = 2;
#endif

// Set below to FALSE to disable autodetection of floppy drives
static const bool detect_floppy_drives = true;

