/*
-----------------------------------------------------
   Application Name: "DIMG"
          Copyright: (C) Copyright David Goodwin, 2008
                     Portions (C) 2001 John Elliott
            License: GNU General Public License
-----------------------------------------------------
    This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

        File Notes:
        ------------------
*/

#include "geom.h"

//int dosgeom(DSK_GEOMETRY *self, const unsigned char *bootsect)
int geom_detect::dosgeom(DiskGeometry *geom, const QByteArray *bootsect)
{
    /* This code derived from LibDsk (C) 2001  John Elliott
     */
        unsigned long lsmax;

        if (!geom || !bootsect) return geom_err::BAD_POINTER;

/* If the boot sector starts 0xE9 or 0xEB, it's DOS. If it starts with
 * three zeroes, it's Atari.
 *  In particular, we have to be careful not to try to identify a
 * PCW 180k floppy, which starts 0x00 0x00 0x28 0x09 */

        if (bootsect->at(0) != (char)0xE9 && bootsect->at(0) != (char)0xEB)
        {
/* However, the Mini Office distribution floppies for the Atari have only
 * two zeroes. So if bytes 0B 0C 15 and 1B look something like a BPB,
 * allow them. This should be sufficient to reject PCW diskettes */
                //if (bootsect[11].toInt() != 0  || bootsect[0x0c].toInt() != 2 ||
                //    bootsect[0x15].toInt() < (int)0xF8 || bootsect[0x1b].toInt() != 0)
                if (bootsect->at(0x0B) != (char)0    || bootsect->at(0x0C) != (char)2 ||
                    bootsect->at(0x15) != (char)0xF8 || bootsect->at(0x1B) != (char)0)
                {
                        if (bootsect[0].toInt() || bootsect[1].toInt() || bootsect[2].toInt())
                                return geom_err::BAD_FORMAT;
                }
        }

        /* Reject fake DOS bootsectors created by 144FEAT */
        if (bootsect->at(511) == (char)144 || bootsect->at(511) == (char)72 || bootsect->at(511) == (char)12)
                return geom_err::BAD_FORMAT;

        //geom->sectorSize   = bootsect[11].toInt() + 256 * bootsect[12].toInt();
        geom->sectorSize   = ((int)bootsect->at(11)) + 256 * ((int)bootsect->at(12));

        //if ((self->dg_secsize % 128) || (self->dg_secsize == 0))
        if ((geom->sectorSize % 128) || (geom->sectorSize == 0))
/* Possible Apricot bootdisk if sector size is 0, or not a multiple of 128 */
/* 		self->dg_secsize = 512; */
                return geom_err::BAD_FORMAT;
        geom->sectorBase   = 1;
        //geom->heads        = bootsect[26].toInt() + 256 * bootsect[27].toInt();
        geom->heads        = ((int)bootsect->at(26)) + 256 * ((int)bootsect->at(27));
        //geom->sectors      = bootsect[24].toInt() + 256 * bootsect[25].toInt();
        geom->sectors      = ((int)bootsect->at(24)) + 256 * ((int)bootsect->at(25));
        if (!geom->heads || !geom->sectors) return geom_err::BAD_FORMAT;
        //lsmax = bootsect[19].toInt() + 256 * bootsect[20].toInt();
        lsmax = ((int)bootsect->at(19)) + 256 * ((int)bootsect->at(20));
        lsmax /= geom->heads;
        lsmax /= geom->sectors;
        geom->cylinders = (int)lsmax;
        /* DOS boot sector doesn't store the data rate. We guess that if there are >12
         * sectors per track, it must have used high density to get them all in */
        geom->dataRate  = (geom->sectors >= 12) ? GeomStr::RATE_HD : GeomStr::RATE_SD;
        /* Similarly it doesn't store the gap lengths: */
        switch(geom->sectors)
        {
                case 8:  geom->rwGap = 0x2A; geom->fmtGap = 0x50; break;
                case 9:  geom->rwGap = 0x2A; geom->fmtGap = 0x52; break;
                case 10: geom->rwGap = 0x0C; geom->fmtGap = 0x17; break;
                case 15: geom->rwGap = 0x1B; geom->fmtGap = 0x50; break;
                case 18: geom->rwGap = 0x1B; geom->fmtGap = 0x50; break;
                default: geom->rwGap = 0x2A; geom->fmtGap = 0x52; break;
        }
       // geom->dg_fm      = 0;
       // geom->dg_nomulti = 0;

        return geom_err::SUCCESS;
}
