/* Project "DIMG" Null Driver Plugin
 *
 * This Software (C) Copyright David Goodwin, 2008, 2009.
 *
 *   This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DQNull_H
#define _DQNull_H

// Qt Headers
#include <QString>
#include <QStringList>
#include <QByteArray>
#include <QFlags>
#include <QtPlugin>
#include <QtDebug>

// Plugin Headers
#include <DQDriver.h>
#include <DiskGeometry.h>

// DQNull headers
#include "about.h"

/** LibDsk Drive Access Plugin.
 */
class DQNull : public QObject, public DQDskDriver {

    Q_OBJECT
    Q_INTERFACES(DQDskDriver)

public:

    DQNull() {}
    ~DQNull() {}

    DQDskDriver::Features getFeatures() const;

    int initialise();

    void displayAbout() const;

    void configure();

    QString getVersionString() const;

    QString getPluginName() const;

    int getLastErrorNumber() const;

    QString errToString(int errorCode) const;

    QStringList getDriveNames() const;

    QStringList getDescriptiveDriveNames() const;

    int openDrive(QString driveName);

    int closeDrive();

    QString currentDrive() const;

    bool isOpen() const;

    bool driveIsWritable(QString driveName) const;

    int writeData(int sector, const QByteArray *data);

    int readData(int sector, QByteArray *data);
    int readData(int cylinder, int head, int sector, QByteArray *data);

    void exiting() { }

    DiskGeometry getDiskGeom();

    int setDiskGeom(QByteArray *boot_sector);
    int setDiskGeom(DiskGeometry dg);
};

#endif
