/* Project "DIMG" Null Driver Plugin
 *
 * This Software (C) Copyright David Goodwin, 2008, 2009.
 *
 *   This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "DQNull.h"


DQDskDriver::Features DQNull::getFeatures() const {
    DQDskDriver::Features f;
    f |= DQDskDriver::F_DisplayAbout;
    return f;
}

int DQNull::initialise() {
    return 0;
}

void DQNull::displayAbout() const  {
    About a;
    a.exec();
}

void DQNull::configure()  {

}

QString DQNull::getVersionString() const {
    return "1.0.0";
}

QString DQNull::getPluginName() const {
    return "Null Driver Plugin";
}

int DQNull::getLastErrorNumber() const {
    return 1;
}

QString DQNull::errToString(int errorCode) const {
    return "Invalid Error Code.";
}

QStringList DQNull::getDriveNames() const {
    QStringList fd;

    return fd;
}

QStringList DQNull::getDescriptiveDriveNames() const {
    QStringList dn;
    return dn;
}

int DQNull::openDrive(QString driveName) {

    return 1;
}

int DQNull::closeDrive() {

    return 1;
}

QString DQNull::currentDrive() const {

    return "";
}

bool DQNull::isOpen() const {

    return false;
}

bool DQNull::driveIsWritable(QString driveName) const {

    return false;
}

int DQNull::writeData(int sector, const QByteArray *data) {

    return 1;
}

int DQNull::readData(int sector, QByteArray *data) {


    return 1;
}

int DQNull::readData(int cylinder, int head, int sector, QByteArray *data) {


    return 1;
}

DiskGeometry DQNull::getDiskGeom() {
    // We will store some geometry info in this
    DiskGeometry dg;

    return dg;
}

int DQNull::setDiskGeom(QByteArray *boot_sector){
    return 1;
}

int DQNull::setDiskGeom(DiskGeometry dg){
    return 1;
}

Q_EXPORT_PLUGIN2(dqnulldrv, DQNull)
