/*
-----------------------------------------------------
   Application Name: "DIMG"
Application Version: 0.2.0
          File Name: constants.h
       File Version: 0.1.0
         Start Date: 30/10/2009
       Last Changed: $LastChangedDate: 2009-12-12 23:04:19 +1300 (Sat, 12 Dec 2009) $
           Revision: $Revision: 125 $
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008
            License: GNU General Public License
   File Description: Constants
-----------------------------------------------------
        This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

        File Notes:
        ------------------
*/
#ifndef VERSION_H
#define VERSION_H

#include <QString>

namespace version {

    typedef enum
    {
        RELEASE_DEVELOPMENT,    /*!< Development release (eg, nightly source snapshot) */
        RELEASE_PREALPHA,       /*!< Pre-alpha testing release */
        RELEASE_ALPHA,          /*!< Alpha release */
        RELEASE_BETA,           /*!< Beta release */
        RELEASE_RC,             /*!< Release Candidate */
        RELEASE_STABLE          /*!< Stable release */
    } ReleaseType;


    // Version information
    const int major_version = 1;    /*!< Applications Major Version number */
    const int minor_version = 0;    /*!< Applications Minor Version number */
    const int patch_level = 0;      /*!< Applications patch level */
    const int revision = 0;         /*!< VCS Revision */

    const ReleaseType release_type = version::RELEASE_STABLE; /*!< The release type (alpha, beta, stable, etc) */
    const int release_series_number = 0; /*!< for alpha/beta/rc releases - the sequence number, ie Beta 4 */

    // Application information
    const QString application_name = "DIMG"; /*!< Name string for the program */

    /** When set to true, version numbers will be displayed as major.minor.patch. For example:
        1.0.5

        When set to false, version numbers will be displayed as major.minor-patch. This is the
        usual version numbering format used on most of my software. For example:
        1.0-5
     */
    const bool use_standard_version_string = false;
}

#endif // VERSION_H
