#ifndef FILEPROPERTIES_H
#define FILEPROPERTIES_H

#include <QtGui/QDialog>
#include <fsentry.h>
#include <FSPlugin.h>
#include <QDir>

namespace Ui {
    class FileProperties;
}

/** Displays information about a file. This will likely be moved into the the filesystem plugin at some point in
  the near future.
 */
class FileProperties : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(FileProperties)
public:
    explicit FileProperties(QWidget *parent = 0);
    virtual ~FileProperties();

    /** Sets the file entry whose properties will be displayed. This method
      does not take ownership of the supplied FSEntry.
      \param e The Filesystem Entry to display the properties dialog for.
     */
    void setFileEntry(FSEntry *e);

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::FileProperties *m_ui;
};

#endif // FILEPROPERTIES_H
