/*
-----------------------------------------------------
   Application Name: "DIMG"
          File Name: aboutdialog.h
       Last Changed: $LastChangedDate: 2009-12-12 23:04:19 +1300 (Sat, 12 Dec 2009) $
           Revision: $Revision: 125 $
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008,2009
            License: GNU General Public License
   File Description: Constants
-----------------------------------------------------
        This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

        File Notes:
        ------------------
*/

#ifndef ABOUTDIALOG_H
#define ABOUTDIALOG_H

#include <QtGui/QDialog>
#include <QString>

#include "constants.h"
#include "utils.h"
#include "version.h"

namespace Ui {
    class AboutDialog;
}

/** An about dialog for the software.
  */
class AboutDialog : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(AboutDialog)
public:
    explicit AboutDialog(QWidget *parent = 0); /*!<Constructor */
    virtual ~AboutDialog(); /*!< Destructor */

    /** Sets data to be displayed in the about dialog.

      \param fsPluginName The name of the loaded filesystem plugin (if any)
      \param fsPluginVersion The version string for the currently loaded filesystem plugin (if any)
      \param dqPluginName The name of the currently loaded Drive Access Plugin (if any)
      \param dqPluginVersion The version string for the currently loaded Drive Access Plugin (if any)
     */
    void setData(QString fsPluginName, QString fsPluginVersion, QString dqPluginName, QString dqPluginVersion);

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::AboutDialog *m_ui;
};

#endif // ABOUTDIALOG_H
