/*
-----------------------------------------------------
   Application Name: "DIMG"
Application Version: 0.2.0
          File Name: aboutdialog.cpp
       Last Changed: $LastChangedDate: 2009-12-12 23:04:19 +1300 (Sat, 12 Dec 2009) $
           Revision: $Revision: 125 $
          Author(s): David Goodwin
          Copyright: (C) Copyright David Goodwin, 2008,2009
            License: GNU General Public License
   File Description: Constants
-----------------------------------------------------
        This file is part of "DIMG".

    This is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this software; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

        File Notes:
        ------------------
*/
#include "aboutdialog.h"
#include "ui_aboutdialog.h"

AboutDialog::AboutDialog(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::AboutDialog)
{
    m_ui->setupUi(this);
}

AboutDialog::~AboutDialog()
{
    delete m_ui;
}

void AboutDialog::setData(QString fsPluginName, QString fsPluginVersion, QString dqPluginName, QString dqPluginVersion) {
    // Setup the table on the about tab:
    QStringList data;
    data << "Filesystem Plugin";
    data << fsPluginName + " version " + fsPluginVersion;
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    data << "Drive Access Plugin";
    data << dqPluginName + " version " + dqPluginVersion;
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    data << "Qt Version";
    data << QString::fromAscii(qVersion());
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    // Include some more detailed build information if the compiler was GNU GCC
#ifdef __GNUC__
    data << "Compiler Version";
    data << "GNU GCC " + QString::fromAscii(__VERSION__);
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();

    data << "Build Date";
    data << QString::fromAscii(__DATE__);
    m_ui->treeWidget->addTopLevelItem(new QTreeWidgetItem(data,0));
    data.clear();
#endif

    // Update Application Name and Version Information
    QString html = m_ui->textBrowser->document()->toHtml();

    html.replace("%APPNAME%",version::application_name);
    html.replace("%VERSION%",utils::versionString());
    m_ui->textBrowser->setHtml(html);
}

void AboutDialog::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
